%
% Create Example 5.1, 5.2, 5.3 and 5.5 in the book
%
% Dongrui WU (dongruiw@usc.edu), 11/16/2008
%

warning off all
clc
clear all
close all

% AWA
X=[9 7 5 4 1];
W=[2 1 8 4 6];
% IWA
devXI=[0.8 0.8 1.2 1.2 3 3 1 1 0.5 0.5] ; %% deviation of XI from X.
devWI=[1 1 0.4 0.4 0.9 0.9 1.6 1.6 1 1]; %% deviation of WI from W.
% LWA
k=0.5;
devXL=k*devXI(1:2:10)';
devWL=k*devWI(1:2:10)';

%% AWA
WA=sum(X.*W)/sum(W)
N=length(X);

%% IWA for Example 5.1
XI(:,1)=X'-devXI([1,3,5,7,9])';
XI(:,2)=X'+devXI([2,4,6,8,10])';
WI(:,1)=W'-devWI([1,3,5,7,9])';
WI(:,2)=W'+devWI([2,4,6,8,10])';
IWAl=EKM(XI(:,1), WI(:,1), WI(:,2),-1);
IWAr=EKM(XI(:,2), WI(:,1), WI(:,2),1);
IWAmean=(IWAl+IWAr)/2;
[IWAl, IWAr]

%% FWA for Example 5.2
XF=[XI(:,1) X' X' XI(:,2)];
WF=[WI(:,1) W' W' WI(:,2)];
n=21;
[temp,yFWA,muFWA]=FWA(XF,WF,n);
FWAcentroid=yFWA*muFWA'/sum(muFWA)

figure
set(gcf,'DefaulttextFontName','times new roman');
set(gcf,'DefaultaxesFontName','times new roman');
set(gcf,'DefaulttextFontAngle','italic');
set(gcf,'DefaulttextFontSize',11);
set(gcf,'DefaultaxesFontSize',10);
set(gcf,'DefaultlineLineWidth',1.2);
set(gcf,'DefaultaxesLineWidth',.35);
subplot(5,2.5,1)
for i=1:N
    plot(XF(i,:),[0 1 1 0]);
    text(XF(i,2)+.2, 1.18, ['X_' num2str(i)],'horizontalalignment','center');
    hold on
end
axis([0,11,0,1.4]);
set(gca,'xtick',[0:10]);
box off
text(11.2,0,'x');
arrow([0,0],[11,0],0.06,pi/10,0.5,[0 0 0],'-');
arrow([0,0.8],[0,1.4],0.06,pi/10,0.5,[0 0 0],'-');
saveas(gcf,'Fig5-6a.eps');

figure
set(gcf,'DefaulttextFontName','times new roman');
set(gcf,'DefaultaxesFontName','times new roman');
set(gcf,'DefaulttextFontAngle','italic');
set(gcf,'DefaulttextFontSize',11);
set(gcf,'DefaultaxesFontSize',10);
set(gcf,'DefaultlineLineWidth',1.2);
set(gcf,'DefaultaxesLineWidth',.35);
subplot(5,2.5,1)
for i=1:N
    plot(WF(i,:),[0 1 1 0]);
    text(WF(i,2)+.2, 1.18, ['W_' num2str(i)],'horizontalalignment','center');
    hold on
end
axis([0,11,0,1.4]);
set(gca,'xtick',[0:10]);
box off
text(11.2,0,'w');
arrow([0,0],[11,0],0.06,pi/10,0.5,[0 0 0],'-');
arrow([0,0.8],[0,1.4],0.06,pi/10,0.5,[0 0 0],'-');
saveas(gcf,'Fig5-6b.eps');

figure
set(gcf,'DefaulttextFontName','times new roman');
set(gcf,'DefaultaxesFontName','times new roman');
set(gcf,'DefaulttextFontAngle','italic');
set(gcf,'DefaulttextFontSize',11);
set(gcf,'DefaultaxesFontSize',10);
set(gcf,'DefaultlineLineWidth',1.2);
set(gcf,'DefaultaxesLineWidth',.35);
subplot(5,2.5,1)
plot(yFWA,muFWA);
text(mean(yFWA(n:n+1))+.4,1.18,'Y_{FWA}','horizontalalignment','center');
axis([0,11,0,1.4]);
set(gca,'xtick',0:10);
box off
text(11.2,0,'y');
%text('Interpreter','latex','String','$\mu_{_{Y_{FWA}}}(y)$','Position',[.2 1.18],'horizontalalignment','left');
arrow([0,0],[11,0],0.06,pi/10,0.5,[0 0 0],'-');
arrow([0,0.8],[0,1.4],0.06,pi/10,0.5,[0 0 0],'-');
saveas(gcf,'Fig5-6c.eps');

%% LWA for Example 5.3
XL=[XF(:,1)-devXL XF(:,[2 3]) XF(:,4)+devXL XF(:,1)+devXL XF(:,[2 3]) XF(:,4)-devXL ones(5,1)];
WL=[WF(:,1)-devWL WF(:,[2 3]) WF(:,4)+devWL WF(:,1)+devWL WF(:,[2 3]) WF(:,4)-devWL ones(5,1)];
[YLWA,yUMF,muUMF,yLMF,muLMF]=LWA(XL,WL,n);
[LWAc,LWACl,LWACr]=centroidIT2(YLWA) 

figure
set(gcf,'DefaulttextFontName','times new roman');
set(gcf,'DefaultaxesFontName','times new roman');
set(gcf,'DefaulttextFontAngle','italic');
set(gcf,'DefaulttextFontSize',11);
set(gcf,'DefaultaxesFontSize',10);
set(gcf,'DefaultlineLineWidth',1.2);
set(gcf,'DefaultaxesLineWidth',.35);
subplot(5,2.5,1)
for i=1:N
    fill(XL(i,[1:4 8:-1:5]),[0 1 1 0 0 XL(i,[9 9]) 0],[0.9,0.9,0.9]);
    hold on
end
for i=1:N
    plot(XL(i,[1:4 8:-1:5]),[0 1 1 0 0 XL(i,[9 9]) 0]);
    text('Interpreter','latex','String',['$$\widetilde{X}_' num2str(i) '$$'],'Position',[mean(XL(i,2:3))+.3 1.18],'horizontalalignment','center');
end
axis([0,11,0,1.4]);
set(gca,'xtick',0:10);
box off
text(11.2,0,'x');
text(0.2,1.33,'u');
arrow([0,0],[11,0],0.06,pi/10,0.5,[0 0 0],'-');
arrow([0,0.8],[0,1.4],0.06,pi/10,0.5,[0 0 0],'-');
saveas(gcf,'Fig5-12a.eps');

figure
set(gcf,'DefaulttextFontName','times new roman');
set(gcf,'DefaultaxesFontName','times new roman');
set(gcf,'DefaulttextFontAngle','italic');
set(gcf,'DefaulttextFontSize',11);
set(gcf,'DefaultaxesFontSize',10);
set(gcf,'DefaultlineLineWidth',1.2);
set(gcf,'DefaultaxesLineWidth',.35);
subplot(5,2.5,1)
for i=1:N
    fill(WL(i,[1:4 8:-1:5]),[0 1 1 0 0 WL(i,[9 9]) 0],[0.9,0.9,0.9]);
    hold on
end
for i=1:N
    plot(WL(i,[1:4 8:-1:5]),[0 1 1 0 0 WL(i,[9 9]) 0]);
        text('Interpreter','latex','String',['$$\widetilde{W}_' num2str(i) '$$'],'Position',[mean(WL(i,2:3))+.3 1.18],'horizontalalignment','center');
end
axis([0,11,0,1.4]);
set(gca,'xtick',0:10);
box off
text(11.2,0,'w');
text(0.2,1.33,'u');
arrow([0,0],[11,0],0.06,pi/10,0.5,[0 0 0],'-');
arrow([0,0.8],[0,1.4],0.06,pi/10,0.5,[0 0 0],'-');
saveas(gcf,'Fig5-12b.eps');

figure
set(gcf,'DefaulttextFontName','times new roman');
set(gcf,'DefaultaxesFontName','times new roman');
set(gcf,'DefaulttextFontAngle','italic');
set(gcf,'DefaulttextFontSize',11);
set(gcf,'DefaultaxesFontSize',10);
set(gcf,'DefaultlineLineWidth',1.2);
set(gcf,'DefaultaxesLineWidth',.35);
subplot(5,2.5,1)
fill([yLMF yUMF(end:-1:1)],[muLMF muUMF(end:-1:1)], [0.9,0.9,0.9]);
hold on
plot([yLMF yUMF(end:-1:1)],[muLMF muUMF(end:-1:1)]);
axis([0, 11, 0, 1.4]);
text('Interpreter','latex','String','$$\widetilde{Y}_{LWA}$$','Position',[mean(yUMF(n:n+1))+.3,1.18],'horizontalalignment','center');
axis([0,11,0,1.4]);
set(gca,'xtick',0:10);
box off
text(11.2,0,'y');
text(0.2,1.3,'u');
arrow([0,0],[11,0],0.06,pi/10,0.5,[0 0 0],'-');
arrow([0,0.8],[0,1.4],0.06,pi/10,0.5,[0 0 0],'-');
saveas(gcf,'Fig5-12c.eps');

%% LWA for Example 5.5
WL=W'*ones(1,8);
[YLWA,yUMF,muUMF,yLMF,muLMF]=LWA(XL,WL,n);
[LWAc,LWACl,LWACr]=centroidIT2(YLWA) 

figure
set(gcf,'DefaulttextFontName','times new roman');
set(gcf,'DefaultaxesFontName','times new roman');
set(gcf,'DefaulttextFontAngle','italic');
set(gcf,'DefaulttextFontSize',11);
set(gcf,'DefaultaxesFontSize',10);
set(gcf,'DefaultlineLineWidth',1.2);
set(gcf,'DefaultaxesLineWidth',.35);
subplot(5,2.5,1)
fill([yUMF yLMF(end:-1:1)],[muUMF muLMF(end:-1:1)], [0.9,0.9,0.9]);
hold on
plot([yUMF yLMF(end:-1:1)],[muUMF muLMF(end:-1:1)]);
axis([0, 11, 0, 1.4]);
text('Interpreter','latex','String','$$\widetilde{Y}_{LWA}$$','position',[mean(yUMF(n:n+1))+.3,1.18],'horizontalalignment','center');
axis([0,11,0,1.4]);
set(gca,'xtick',0:10);
box off
text(11.2,0,'y');
text(0.2,1.3,'u');
arrow([0,0],[11,0],0.06,pi/10,0.5,[0 0 0],'-');
arrow([0,0.8],[0,1.4],0.06,pi/10,0.5,[0 0 0],'-');
saveas(gcf,'Fig5-14.eps');
